$(document).ready(function(){

    var add_payment_btn = '<button class="btn btn-success"'+
                                    'data-toggle="modal"'+
                                    'data-target="#add-invoice-transfer-modal"'+
                                    
                            '>'+
                                '<i class="fa fa-exchange" aria-hidden="true"></i>'+
                            '</button>';

    $('.add_pay_btn').append(add_payment_btn);

    $(".invoice_booking_id").on('blur', function(){

        var bookingID = $(this).val();

        var invoiceBookingID = $('.pos_booking_id').val();

        if(invoiceBookingID == bookingID) {
            alert('This booking ID belongs to the current invoice.');
            return false;
        }

        if(bookingID){
            $.ajax({
                url: getBaseURL() + 'check_booking_existency',
                type: "POST",
                dataType: "json",
                data: {
                    booking_id: bookingID
                },
                dataType: "json",
                success: function(resp) {
                    if(resp.success){
                        innGrid.populateInvoicePaymentInformation(resp.amount);
                    } else {
                        alert(resp.error);
                        innGrid.populateInvoicePaymentInformation(0);
                    }
                }
            });
        }

    });

    $("body").on("click", ".add_inv_pay_button", function () {

        var invoiceBookingId = $('.invoice_booking_id').val();

        if(invoiceBookingId == ''){
            alert('Please enter the booking ID');
            return false;
        }

        $(this).html("Processing. . .");
        $(this).prop("disabled", true);
        
        $.ajax({
            url    : getBaseURL() + 'add_invoice_transfer_payment',
            method : 'post',
            dataType: 'json',
            data   : {
                booking_id      : invoiceBookingId,
                payment_date    : innGrid._getBaseFormattedDate($("input[name='payment_date']").val()),
                payment_type_id : $("select[name='inv_payment_type_id']").val(),
                customer_id     : $("select[name='customer_id']").val(),
                payment_amount  : $("input[name='invoice_pay_amount']").val(),
                description     : $(".invoice_description").val(),
                folio_id        : $('#current_folio_id').val(),
                selected_gateway : $('input[name="'+innGrid.featureSettings.selectedPaymentGateway+'_use_gateway"]').data('gateway_name'),
                paid_by_booking_id : $("#booking_id").val()
            },
            success: function (data) { 
                console.log('expire ',data);
                if (data == "You don't have permission to access this functionality."){
                    alert(data);
                    $(that).prop("disabled", false);
                    return;
                }
                
                if(data.success){
                   window.location.reload();
                }
                // else if(data.expire)
                // {
                //     window.location.href = getBaseURL() + 'settings/integrations/payment_gateways';
                // }
                else
                {
                    var error_html = "";
                    // console.log(jQuery.isArray( data.message ));
                    if(jQuery.isArray( data.message )){
                        $.each(data.message, function(i,v){
                            error_html += v.description+'\n';
                        });
                        console.log(error_html);
                        $('#display-errors').find('.modal-body').html(error_html.replace(/\n/g,'<br/>'));
                        $('#display-errors').modal('show');
                        // alert(error_html);
                    } else {
                        alert(data.message ? data.message : data);
                    }
                    
                    
                    $(that).prop("disabled", false);
                }
            }
        });
    });

});

// populate Payment Amount and Payment Description based on pay_for selection ("this invoice only" or "all bookings belonging to this customer")
innGrid.populateInvoicePaymentInformation = function(amount) {
    
    var bookingID = $("[name='invoice_booking_id']").val();
    console.log('bookingID',bookingID);
    if (bookingID != "" && bookingID != undefined && amount > 0) {

        $("input[name='invoice_pay_amount']").prop("readonly", true);
        $("input[name='invoice_pay_amount']").val(number_format(amount, 2, ".", ""));
    } 
    // else {
    //     $("input[name='invoice_pay_amount']").prop("readonly", false);
    //     $("input[name='invoice_pay_amount']").val(number_format(parseFloat($("#amount_due").text().replace(/,/g, '')), 2, ".", ""));
    //     $("textarea[name='description']").val("");
    // }
}

var invPayData = '';

innGrid.get_invoice_payments = function(booking_id){
    if(booking_id){
        $.ajax({
            url: getBaseURL() + 'get_invoice_payments/'+booking_id,
            type: "POST",
            dataType: "json",
            data: {},
            dataType: "json",
            success: function(resp) {
                console.log('resp',resp);

                if(resp.invoice_pay_data){

                    invPayData = resp;

                    var totalAmount = 0;

                    var htmlContent = '<hr/>'+
                                    '<div class="h2 text-left payment_div">'+
                                        '<span alt="invoice payments" title="invoice payments">Invoice Payments</span>'+
                                    '</div>';

                    htmlContent += '<table class="table table-hover"><thead>'+
                    '<tr>'+
                        '<th class="text-left"><span alt="date" title="date">Date</span></th>'+
                        '<th class="text-left"><span alt="description" title="description">Description</span></th>'+
                        '<th class="text-left"><span alt="paid_for" title="paid_for">Paid for</span></th>'+
                        '<th class="text-left"><span alt="paid_by" title="paid_by">Paid by</span></th>'+
                        '<th class="text-left"><span alt="payment_type" title="payment_type">Payment Type</span></th>'+
                        '<th class="text-left"><span alt="Status" title="Status">Status</span></th>'+
                        '<th class="text-right"><span alt="amount" title="amount">Amount</span></th>'+
                        '<th class="delete-td"></th>'+
                    '</tr>'+
                    '</thead><tbody>'; // Start building the table body

                    var customerName = $('.customer_name').val();

                    $.each(resp.invoice_pay_data, function (key, value) {
                        // console.log('key', key);
                        // console.log('value', value);
                        
                        // Dynamically create a row for each entry in the data
                        htmlContent += '<tr class="payment_row" payment_id="' + value.payment_id + '" id="' + value.payment_id + '" data-is_gateway="' + 0 + '" data-pay-type="' + 'Catured' + '" data-remaining-amount="' + '' + '">'+
                                            '<td>' + value.selling_date + '</td>' + // Replace 'field1' with actual keys from the data
                                            '<td>' + 'Pay for Booking ID: <a target="_blank" href="'+ getBaseURL() + 'invoice/show_invoice/' + value.booking_id +'" > ' + value.booking_id + '</a></td>' + // Replace 'field2' with actual keys from the data
                                            '<td>' + value.customer_name + '</td>' + // Replace 'field2' with actual keys from the data
                                            '<td>' + customerName + '</td>' + // Replace 'field2' with actual keys from the data
                                            '<td>' + value.payment_type + '</td>' + // Replace 'field3' with actual keys from the data
                                            '<td>' + 'Catured' + '</td>' + // Replace 'field4' with actual keys from the data
                                            '<td class="text-right payment">' + value.amount + '</td>' + // Replace 'field5' with actual keys from the data
                                            '<td>' + '' + '</td>' + // Replace 'field5' with actual keys from the data
                                        '</tr>';
                        totalAmount += parseFloat(value.amount);
                    });

                    htmlContent += '</tbody><tfoot>'+
                                                    '<tr>'+
                                        '<td colspan="6">'+
                                            '<div class="h4 text-muted">'+
                                                '<div class="col-xs-12 payment_total">'+
                                                    '<div class="col-xs-6">'+
                                                    '</div>'+
                                                    '<div class="col-xs-4 text-right smaller_fonts payments_text_spacing">'+
                                                        '<span alt="total" title="total">Total</span>:'+
                                                    '</div>'+
                                                    '<div class="col-xs-2 text-right smaller_fonts" id="payment_total">'+number_format(totalAmount, 2, ".", ",")+'</div>'+
                                                '</div>'+
                                            '</div>'+
                                        '</td>'+
                                    '</tr>'+
                                    '</tfoot></table>'; // Close the table body and the table

                    // Insert the generated table after the element with ID #payment-table
                    $(htmlContent).insertAfter('#payment-table').find('tfoot');
                }
            }
        });
    }
}

var bookingId = $("#booking_id").val();

innGrid.get_invoice_payments(bookingId);
console.log('invPayData',invPayData);